/************************************************************************************
* This module contains the ICG module defines etc.
* 
* Note! Support for selecting external crystal and external clock source from Abel 2.0
*
* Author(s):  Michael V. Christensen
*
* (c) Copyright 2004, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected: 29-03-01
* Last Tested:
*
* History:
*	11/09/06	HS	init setup for HPRFGW (__TAG needs cleanup)
*
************************************************************************************/
/* not going to use*/

#ifndef _HPRFGW_RFICG_H
#define _HPRFGW_RFICG_H

#include "HPRFGW_RFEmbeddedTypes.h"
#include "HPRFGW_RFMc1319xDrv.h"
#include "HPRFGW_RFMc1319xReg.h"

// **************************************************************************
// debug defines

// **************************************************************************
// User configuration defines

// Select one type of external clock source.
#define USE_EXT_CLK // Use external crystal
//#define USE_ABEL_CLKO // Use Abel CLKO output - select Abel CLKO frequency below
							  

#ifdef USE_ABEL_CLKO
// If Abel version 2.0/2.1 CLKO clock is selected - select one Abel CLKO output frequency.
// Note! All values will give a CPU frequency = 16 MHz and a bus frequency = 8 MHz
// However, 32,78 KHz and 16,39 KHz will give 8,39 MHz as bus frequency. This has impact on
// the UART baud rate and SPI clock.

	//#define USE_16MHZ_CLKO // DO NOT SELECT THIS - WILL NOT WORK (MAX. 10 MHz)
	//#define USE_8MHZ_CLKO
	//#define USE_4MHZ_CLKO
	//#define USE_2MHZ_CLKO
	//#define USE_1MHZ_CLKO // REQUIRES ADDITIONAL NOPS
	#define USE_62_5KHZ_CLKO
	//#define USE_32_78KHZ_CLKO
	//#define USE_16_39KHZ_CLKO // REQUIRES ADDITIONAL NOPS

// If Abel version 2.0/2.1 CLKO clock is selected - select one Abel CLKO output frequency.
// Note! All values will give a CPU frequency = 32 MHz and a bus frequency = 16 MHz
// However, 32,78 KHz and 16,39 KHz will give 16,78 MHz as bus frequency. This has impact on
// the UART baud rate and SPI clock.
    //#define USE_32_78KHZ_CLKO_AT_16_78HMZ
    //#define USE_32_78KHZ_CLKO_AT_14_24HMZ
    
#endif USE_ABEL_CLKO

// **************************************************************************
// Abel CLKO defines

// Abel CLKO register valuedefines
#define ABEL_16MHZ		0x0000
#define ABEL_8MHZ		0x0001
#define ABEL_4MHZ		0x0002
#define ABEL_2MHZ		0x0003
#define ABEL_1MHZ		0x0004
#define ABEL_62_50KHZ	0x0005
#define ABEL_32_78KHZ	0x0006
#define ABEL_16_39KHZ	0x0007

// **************************************************************************

#define LOOP_COUNTER_VALUE			100

// **************************************************************************
// Configuration dependend defines

#ifdef USE_ABEL_CLKO

#ifdef USE_16MHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_16MHZ_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_16MHZ
#endif USE_16MHZ_CLKO

#ifdef USE_8MHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_8MHZ_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_8MHZ
#endif USE_8MHZ_CLKO

#ifdef USE_4MHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_4MHZ_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_4MHZ
#endif USE_4MHZ_CLKO

#ifdef USE_2MHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_2MHZ_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_2MHZ
#endif USE_2MHZ_CLKO

#ifdef USE_1MHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_1MHZ_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_1MHZ
#endif USE_1MHZ_CLKO

#ifdef USE_62_5KHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_62_5_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_62_50KHZ
#endif USE_62_5KHZ_CLKO

#ifdef USE_32_78KHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_32_78_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_32_78KHZ
#endif USE_32_78KHZ_CLKO

#ifdef USE_16_39KHZ_CLKO
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_16_39_TO_8MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_16_39KHZ
#endif USE_16_39KHZ_CLKO


#ifdef USE_32_78KHZ_CLKO_AT_16_78HMZ
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_32_78_TO_16_78MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_32_78KHZ
#endif USE_32_78KHZ_CLKO_AT_16_78HMZ

#ifdef USE_32_78KHZ_CLKO_AT_14_24HMZ
	#define DEFAULT_SETUP_ICG_MODULE	ABEL_CLOKO_32_78_TO_14_24MHZ_ICG
	#define SELECT_ABEL_CLOCK			ABEL_32_78KHZ
#endif USE_32_78KHZ_CLKO_AT_14_24_HMZ


#define DEFAULT_SETUP_ABEL_CLOCK		MC1319xDrv_WriteClockoCtrl(0x3640 | SELECT_ABEL_CLOCK);
#define NV_SETUP_ABEL_CLOCK				  MC1319xDrv_WriteClockoCtrl(NV_RAM_ptr->Abel_Clock_Out_Setting);

#endif USE_ABEL_CLKO

// **************************************************************************
// Macros

#define SETUP_ICG_MODULE	

#define SETUP_ABEL_CLOCK	
							
// **************************************************************************

// Some NOPS
#define SOME_NOPS	asm(nop); \
			 		asm(nop); \
			 		asm(nop); \
			 		asm(nop); \
			 		asm(nop); \
			 		asm(nop);
							      
// These special low CLKO requires additional settling nops
#if defined USE_16_39KHZ_CLKO | defined USE_1MHZ_CLKO | defined USE_16MHZ_CLKO
	// A few NOPS in loop for clock to settle.
	#define WAIT_FOR_STABLE_CLOCK	{                           \
								   	uint8_t i;                  \
										for(i = 50; i > 0; i--) \
											SOME_NOPS           \
									}
#else
	// A few NOPS for clock to settle.
	#define WAIT_FOR_STABLE_CLOCK	SOME_NOPS
#endif 							   
// **************************************************************************

#ifdef ENABLE_DEBUG_MEASURING

// This macro can be used to measure the bus frequency.

#define MEASURING_BUS_CLOCK     

#else
#define MEASURING_BUS_CLOCK // Empty function

#endif ENABLE_DEBUG_MEASURING

// **************************************************************************

#ifdef ENABLE_LEDS

// Setup port output LED1, LED2, LED3 and LED4
#define SETUP_LED_PORT 		


// LED's on Axiom development board are inverted.
// I.e. port = "1" => LED off and port = "0" => LED on
#define SET_LED1			
#define SET_LED2		 	
#define SET_LED3			
#define SET_LED4			

#define CLEAR_LED1			
#define CLEAR_LED2			
#define CLEAR_LED3			
#define CLEAR_LED4			


#define TOGGLE_LED1			

#define TOGGLE_LED2			         

#define TOGGLE_LED3			

#define TOGGLE_LED4			
								
#else ENABLE_LEDS

// Use empty defines

#define SETUP_LED_PORT

// LED's on Axiom development board are inverted.
// I.e. port = "1" => LED off and port = "0" => LED on
#define SET_LED1
#define SET_LED2
#define SET_LED3
#define SET_LED4

#define CLEAR_LED1
#define CLEAR_LED2
#define CLEAR_LED3
#define CLEAR_LED4

#define TOGGLE_LED1
#define TOGGLE_LED2
#define TOGGLE_LED3
#define TOGGLE_LED4
								
#endif ENABLE_LEDS

// **************************************************************************

// Macros and Prototypes
void Clock_Setup(void);
#define ICG_IsFllLocked() (ICGS1 & ICG_FLL_LOCKED)


// **************************************************************************

#endif _ICG_H